package bmserv.resources;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

import bmserv.Server;
import bmserv.TemplateEngine;
import bmserv.model.Tagging;

@Path("/tagging")
public class TaggingResource {
	@GET
	@Path("/id/{taggingid}")
	@Produces("text/xml")
	public bmserv.model.Tagging getTaggingFromId(@PathParam("taggingid") String taggingid) {
		Tagging tg = Server.tgh.getTaggingFromId(taggingid);
		return tg;		
	}
	
	@GET
	@Path("/all")
	@Produces("text/xml")
	public bmserv.model.handlers.TaggingHandler getAllTaggings() {
		return Server.tgh;
	}
		
}
