package bmserv.resources;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;

import bmserv.Server;
import bmserv.TemplateEngine;
import bmserv.model.Bookmark;

@Path("/bookmark")
public class BookmarkResource {
	@GET
	@Path("/id/{bmid}")
	@Produces("text/xml")
	public bmserv.model.Bookmark getBookmarkFromId(@PathParam("bmid") String bmid) {
		Bookmark bm = Server.bmh.getBookmarkFromId(bmid);
		return bm;
	}
	
	
	@GET
	@Path("/all")
	@Produces("text/xml")
	public bmserv.model.handlers.BookmarkHandler getAllBookmarks() {
		return Server.bmh;
	}

	@GET
	@Path("/id/{bmid}/html")
	@Produces("text/html")
	public String getBookmarkFromIdHtml(@Context HttpServletRequest req, @PathParam("bmid") String bmid) {
		TemplateEngine.setSession(req.getSession());
		Bookmark bm = Server.bmh.getBookmarkFromId(bmid);
		final StringBuilder sb = new StringBuilder();
		sb.append("\n<h1>Bookmark d&eacute;tail</h1>\n<h2>");
		sb.append(bm.getTitle())
		.append("</h2>\n<p><a href='")
		.append(bm.getUrlstr())
		.append("'>")
		.append(bm.getDescription())
		.append("</a></p>");
		return TemplateEngine.build(sb.toString());
	}	
	
	@GET
	@Path("/all/html")
	@Produces("text/html")
	public String getAllBookmarksHtml(@Context HttpServletRequest req) {
		TemplateEngine.setSession(req.getSession());
		final StringBuilder sb = new StringBuilder();
		sb.append("<h1>Bookmarks</h1>\n<table border='1' cellpadding='2' cellspacing='0' style='margin-top:10px'>");
		sb.append("\n<tr style='font-weight:bold;'><td>ID</td><td>Title</td><td>URL</td><td>ID Auteur</td><td>Description</td></tr>");
		List<Bookmark> blist = Server.bmh.getBookmarks();
		for (Bookmark b : blist) {
			sb.append("\n<tr><td>")
			.append(b.getId())
			.append("</td><td>")
			.append(b.getTitle())
			.append("</td><td>")
			.append(b.getUrlstr())
			.append("</td><td>")
			.append(b.getAuthid())
			.append("</td><td>")
			.append(b.getDescription())				
			.append("</td></tr>");
		}
		sb.append("\n</table>");
		return TemplateEngine.build(sb.toString());
	}		
}
