package bmserv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import javax.xml.bind.JAXB;

/**
 * Classe chargee de la serialisation des donnees.
 * @author ndelafor
 *
 */
public class Writer {
	private static String users_fname;
	private static String tags_fname;
	private static String bookmarks_fname;
	private static String taggings_fname;
	private static String backup_suffix;
	private static String datarep_prefix;
	private static String backuprep_prefix;

	static {
		Properties prop = new Properties();
		try {
			prop.load(new FileInputStream("./conf/server.properties"));
			users_fname = prop.getProperty("users.filename");
			tags_fname = prop.getProperty("tags.filename");
			bookmarks_fname = prop.getProperty("bookmarks.filename");
			taggings_fname = prop.getProperty("taggings.filename");
			backup_suffix = prop.getProperty("backup.suffix");
			datarep_prefix = prop.getProperty("data.repository.prefix");
			backuprep_prefix = prop.getProperty("backup.repository.prefix");

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	
	/**
	 * Serialisation de toute la hierarchie d'objets
	 * Les anciens fichiers sont préservés pour une restauration en cas de probleme voir {@link Loader}.
	 * @throws IOException
	 */
	public static void serialize() throws IOException {
		serializeBookmarks();
		serializeTags();
		serializeUsers();
		serializeTaggings();
	}
	
	public static void serializeBookmarks() {
		File fbm = new File(datarep_prefix + bookmarks_fname);
		// On cree une copie de sauvegarde des fichiers precedents en cas de probleme 
		fbm.renameTo(new File(backuprep_prefix + bookmarks_fname+backup_suffix));
		try {
			fbm.createNewFile();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		JAXB.marshal(Server.bmh, fbm);
		System.out.print("Bookmarks sérialisés");
		Server.bmh.print();
	}

	public static void serializeTags() {
		File ftags = new File(datarep_prefix + tags_fname);		
		// On cree une copie de sauvegarde des fichiers precedents en cas de probleme 
		ftags.renameTo(new File(backuprep_prefix + tags_fname+backup_suffix));
		try {
			ftags.createNewFile();
		} catch (IOException e) {
			e.printStackTrace();
		}
		// Serialisation
		JAXB.marshal(Server.th, ftags);
		System.out.print("Tags sérialisés");
		Server.th.print();
	}

	public static void serializeUsers() {
		File fusers = new File(datarep_prefix + users_fname);
		// On cree une copie de sauvegarde des fichiers precedents en cas de probleme 
		fusers.renameTo(new File(backuprep_prefix + users_fname+backup_suffix));
		try {
			fusers.createNewFile();
		} catch (IOException e) {
			e.printStackTrace();
		}
		// Serialisation
		JAXB.marshal(Server.uh, fusers);
		System.out.print("Utilisateurs sérialisés");
		Server.uh.print();		
	}
	public static void serializeTaggings() {
		File ftg = new File(datarep_prefix + taggings_fname);
		// On cree une copie de sauvegarde des fichiers precedents en cas de probleme 
		ftg.renameTo(new File(backuprep_prefix + taggings_fname+backup_suffix));
		try {
			ftg.createNewFile();
		} catch (IOException e) {
			e.printStackTrace();
		}
		// Serialisation
		JAXB.marshal(Server.tgh, ftg);
		System.out.print("Taggings sérialisés");
		Server.tgh.print();		
	}

}
