package bmserv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

import bmserv.exceptions.LoadFileException;
import bmserv.exceptions.NoBackupFileException;
import bmserv.model.handlers.BookmarkHandler;
import bmserv.model.handlers.TagHandler;
import bmserv.model.handlers.TaggingHandler;
import bmserv.model.handlers.UserHandler;
import java.awt.Toolkit;

/**
 * Classe de chargement des donnees dans la structure objet du serveur. Les
 * fichiers lus ont ete generes par la classe {@link Writer}.
 * 
 * @author ndelafor
 * 
 */
public class Loader {
	private static String users_fname;
	private static String tags_fname;
	private static String bookmarks_fname;
	private static String taggings_fname;
	private static String backup_suffix;
	private static String datarep_prefix;
	private static String backuprep_prefix;

	static {
		Properties prop = new Properties();
		try {
            File f = new File(".");
            System.out.println("chemin d'execution = " + f.getAbsolutePath());
            
			prop.load(new FileInputStream("./conf/server.properties"));
			users_fname = prop.getProperty("users.filename");
			tags_fname = prop.getProperty("tags.filename");
			bookmarks_fname = prop.getProperty("bookmarks.filename");
			taggings_fname = prop.getProperty("taggings.filename");
			backup_suffix = prop.getProperty("backup.suffix");
			datarep_prefix = prop.getProperty("data.repository.prefix");
			backuprep_prefix = prop.getProperty("backup.repository.prefix");

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static void load() {
		try {
			loadUsers();
			loadTags();
			loadBookmarks();
			loadTaggings();
		} catch (Exception e) {
			e.printStackTrace();
			System.out
					.println("Un problème est survenu pendant le chargement des données. \nLes fichiers de sauvegarde ont été restaurés.");
//			restore();
		}
	}

	/**
	 * Restauration des fichiers de backup en cas de probleme (corruption de
	 * fichier etc)
	 */
	public static void restore() {
		try {
			restoreUsers();
			restoreTags();
			restoreBookmarks();
			restoreTaggings();
			load();
		} catch (NoBackupFileException e) {
			e.printStackTrace();
		}
	}

	public static void loadUsers() throws LoadFileException {
		try {
			File fusers = new File(datarep_prefix + users_fname);
			Server.uh = JAXB.unmarshal(fusers, UserHandler.class);
			System.out.print(fusers.getAbsolutePath());
			Server.uh.print();
		} catch (DataBindingException e) {
			throw new LoadFileException(
					"Erreur au chargement du fichier des utilisateurs");
		}
	}

	public static void loadTags() throws LoadFileException {
		try {
			File ftags = new File(datarep_prefix + tags_fname);
			Server.th = JAXB.unmarshal(ftags, TagHandler.class);
			System.out.print(ftags.getAbsolutePath());
			Server.th.print();
		} catch (DataBindingException e) {
			throw new LoadFileException(
					"Erreur au chargement du fichier des tags");
		}
	}

	public static void loadBookmarks() throws LoadFileException {
		try {
			File fbm = new File(datarep_prefix + bookmarks_fname);
			Server.bmh = JAXB.unmarshal(fbm, BookmarkHandler.class);
			System.out.print(fbm.getAbsolutePath());
			Server.bmh.print();
		} catch (DataBindingException e) {
			throw new LoadFileException(
					"Erreur au chargement du fichier des bookmarks");
		}
	}

	public static void loadTaggings() throws LoadFileException {
		try {
			File ftg = new File(datarep_prefix + taggings_fname);
			Server.tgh = JAXB.unmarshal(ftg, TaggingHandler.class);
			System.out.print(ftg.getAbsolutePath());
			Server.tgh.print();
		} catch (DataBindingException e) {
			throw new LoadFileException(
					"Erreur au chargement du fichier des taggings");
		}
	}

	public static void restoreUsers() throws NoBackupFileException {
		File fusers = new File(backuprep_prefix + users_fname + backup_suffix);
		if (fusers.exists())
			fusers.renameTo(new File(datarep_prefix + users_fname));
		else
			throw new NoBackupFileException(
					"Aucun fichier de sauvegarde pour n'a été trouvé pour les utilisateurs");
	}

	public static void restoreTags() throws NoBackupFileException {
		File fusers = new File(backuprep_prefix + tags_fname + backup_suffix);
		if (fusers.exists())
			fusers.renameTo(new File(datarep_prefix + tags_fname));
		else
			throw new NoBackupFileException(
					"Aucun fichier de sauvegarde pour n'a été trouvé pour les tags");
	}

	public static void restoreBookmarks() throws NoBackupFileException {
		File fusers = new File(backuprep_prefix + bookmarks_fname
				+ backup_suffix);
		if (fusers.exists())
			fusers.renameTo(new File(datarep_prefix + bookmarks_fname));
		else
			throw new NoBackupFileException(
					"Aucun fichier de sauvegarde pour n'a été trouvé pour les bookmarks");
	}

	public static void restoreTaggings() throws NoBackupFileException {
		File fusers = new File(backuprep_prefix + taggings_fname
				+ backup_suffix);
		if (fusers.exists())
			fusers.renameTo(new File(datarep_prefix + taggings_fname));
		else
			throw new NoBackupFileException(
					"Aucun fichier de sauvegarde pour n'a été trouvé pour les taggings");
	}
}