package bmserv.resources;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;

import bmserv.Server;
import bmserv.TemplateEngine;
import bmserv.model.User;

@Path("/user")
public class UserResource {
	@GET
	@Path("/id/{userid}")
	@Produces("text/xml")
	public bmserv.model.User getUserFromId(@PathParam("userid") String userid) {
		User u = Server.uh.getUserFromId(userid);
		return u;
	}

	@POST
	@Path("/create")
	@Produces("text/html")
	@Consumes("application/x-www-form-urlencoded")
	public String create(@Context HttpServletRequest req, MultivaluedMap<String, String> formParams){
		TemplateEngine.setSession(req.getSession());
		String login = formParams.getFirst("login");
		String firstname = formParams.getFirst("firstname");
		String lastname = formParams.getFirst("lastname");
		Server.uh.createUser(login, lastname, firstname);
		return TemplateEngine.goHome();
	}	
	
	@POST
	@Path("/login")
	@Produces("text/html")
	@Consumes("application/x-www-form-urlencoded")
	public String login(@Context HttpServletRequest req, @FormParam("login") String login) {
		TemplateEngine.setSession(req.getSession());
		if(Server.uh.getUserFromLogin(login)!=null){
			HttpSession session = req.getSession();
			session.setAttribute("userid", User.createUserId(login));
			System.out.println("USER LOGIN : "+login);
		}
		return TemplateEngine.goHome();
	}	
	
	@GET
	@Path("/logout")
	@Produces("text/html")
	public String logout(@Context HttpServletRequest req) {
		TemplateEngine.setSession(req.getSession());
		HttpSession session = req.getSession();
		String userid = (String) session.getAttribute("userid");
		System.out.println("USER LOGOUT : "+userid);
		session.removeAttribute("userid");
		return TemplateEngine.redirect("/", 2, "Vous avez été déconnecté. Vous allez être redirigé dans 2 secondes.");
	}	
	
	@GET
	@Path("/all/")
	@Produces("text/xml")
	public bmserv.model.handlers.UserHandler getAllUsers() {
		return Server.uh;
	}

	@GET
	@Path("/all/html")
	@Produces("text/html")
	public String getAllUsersHtml(@Context HttpServletRequest req) {
		TemplateEngine.setSession(req.getSession());
		final StringBuilder sb = new StringBuilder();
		sb.append("<h1>Utilisateurs</h1>\n<table border='1' cellpadding='2' cellspacing='0' style='margin-top:10px'>");
		sb.append("\n<tr style='font-weight:bold;'><td>Login</td><td>ID</td><td>Firstname Lastname</td></tr>");			
		List<User> ulist = Server.uh.getUsers();
		for (User u : ulist) {
			sb.append("\n<tr><td>")
				.append(u.getLogin())
				.append("</td><td>")
				.append(u.getId())
				.append("</td><td>")
				.append(u.getFirstname()).append(" ").append(u.getLastName())
				.append("</td></tr>");
		}
		sb.append("\n</table>");
		return TemplateEngine.build(sb.toString());
	}

}
