package bmserv.model.handlers;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import bmserv.Server;
import bmserv.Writer;
import bmserv.model.Tag;

/**
 * Gestion des instances de {@link Tag}.
 * {@link TagHandler} implemente les methodes CRUD sur les {@link Tag Tags}.
 * @author ndelafor 
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "tags")
public class TagHandler {
	@XmlElement(name = "tag", required=true)
	private static List<Tag> tags = new ArrayList<Tag>();

	public TagHandler() {
	}
	/**
	 * Creation d'un nouveau {@link Tag} et generation d'un nouvel ID en fonction des parametres.
	 * @param label intitule du {@link Tag}, ce label est encode au format URLEncode pour la creation de l'ID (voir la methode {@link Tag Tag.createTagId(label)}.
	 * @throws UnsupportedEncodingException
	 */
	public void createTag(final String label) {
		if(getTagFromId(Tag.createTagId(label)) == null) {
			tags.add(new Tag(label));
			Writer.serializeTags();
		}
	}
	
	/**
	 * Renvoie la liste de tous les {@link Tag}
	 * @return une collection de {@link Tag Tags}
	 */
	public List<Tag> getTags() {
		return tags;
	}

	/**
	 * Permet de recuperer une instance de {@link Tag} a partir de son ID
	 * @param tagid l'ID du {@link Tag} a recuperer
	 * @return le Tag
	 */
	public Tag getTagFromId(String tagid) {
		for(Tag t : tags){
			if(t.getId().equals(tagid)) return t;
		}
		return null;
	}
	
	public void updateTagFromId(final String oldtagid, final String newlabel){
		Tag t = getTagFromId(oldtagid);
		t.setLabel(newlabel);
		Server.tgh.updateTaggingsWithTagId(oldtagid, t.getId());
		Writer.serializeTags();
	}
	
	public boolean removeTag(Tag t){
		Server.tgh.removeTaggingsWithTagId(t.getId());
		boolean b = tags.remove(t); 
		Writer.serializeTags();
		return b; 
	}
	/**
	 * Methode utilitaire pour afficher le nombre d'&eacute;l&eacute;ments contenus dans la liste.
	 */
	public void print(){
		System.out.print("=> "+tags.size()+" éléments chargés\n");
	}	
}