package bmserv.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import bmserv.Utils;
import bmserv.model.handlers.TagHandler;

/**
 * Bean qui implementent le modele de Tag.
 * Un {@link Tag} est un label associ&eacute; &agrave; un ID.
 * @author ndelafor
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "tag", propOrder={
		"id",
		"label"
	}
)
@XmlRootElement(name = "tag")
public class Tag {
	@XmlElement(name = "id")
	private String id;
	@XmlElement(name = "label")
	private String label;
	
	/**
	 * Constructeur vide. Utilis&eacute; par JAXB.
	 */
	public Tag() {}

	/**
	 * Constructeur param&eacute;tr&eacute; pour l'ajout dynamique de {@link Tag} depuis le {@link TagHandler}.
	 * @param label
	 * @throws UnsupportedEncodingException
	 */
	public Tag(final String label) {
		this.label = label;
		this.id = createTagId(label);
	}

	/**
	 * Getter sur l'ID du {@link Tag}.
	 * @return l'ID du tag
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * Getter sur le label du {@link Tag}.
	 * @return le label du tag
	 */
	public String getLabel() {
		return label;
	}

	public void setLabel(final String label) {
		this.label = label;
		this.id = createTagId(label);
	}

	/**
	 * Methode statique de creation d'un ID de {@link Tag}.<br/>
	 * @param label le label du tag
	 * @return string contenant l'ID du tag
	 */
	public static String createTagId(String label) {
		return Utils.md5Encode(label);
	}
}
